#define SPWM    PORTC.0
#define SPWMD   DDRC.0


// Timer1 overflow interrupt service routine
interrupt [TIM1_OVF] void timer1_ovf_isr(void)
{
SPWM=0;
}

// Timer1 output compare A interrupt service routine
interrupt [TIM1_COMPA] void timer1_compa_isr(void)
{
SPWM=1;
}

void load_pwm(unsigned int pw){
OCR1AH=pw>>8;
OCR1AL=pw & 0xFF;
}
void wait_us(unsigned int val){
 int i;
 for(i=0;i<val-5;i++)    
        delay_us(1);
}

void light_on(unsigned int d_us){
unsigned int i;
for(i=0;i<0xFFFF-50;i+=50){
 load_pwm(i);
 wait_us((unsigned int)d_us);
}
load_pwm(0xFFFE);
}

void light_off(unsigned int d_us){
unsigned int i;
for(i=0;i<0xFFFF-50;i+=50){
 load_pwm(0xFFFF-50-i);
 wait_us((unsigned int)d_us);
}
load_pwm(20);
}

void light_effect1(unsigned int d_us){
light_off(d_us);
light_on(d_us);
}

void init_spwm(void){

// Timer/Counter 1 initialization
// Clock source: System Clock
// Clock value: 8000.000 kHz
// Mode: Normal top=FFFFh
// OC1A output: Discon.
// OC1B output: Discon.
// Noise Canceler: Off
// Input Capture on Falling Edge
// Timer1 Overflow Interrupt: On
// Input Capture Interrupt: Off
// Compare A Match Interrupt: On
// Compare B Match Interrupt: Off
TCCR1A=0x00;
TCCR1B=0x01;
TCNT1H=0x00;
TCNT1L=0x01;
ICR1H=0x00;
ICR1L=0x00;
OCR1AH=0x00;
OCR1AL=0x01;
OCR1BH=0x00;
OCR1BL=0x00;
// Timer(s)/Counter(s) Interrupt(s) initialization
TIMSK |=0x14;
SPWMD=1;
SPWM=1;
load_pwm(1);
}